/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzacraft.compat.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import com.tiviacz.pizzacraft.init.ModBlocks;
import com.tiviacz.pizzacraft.recipes.mortar.MortarRecipe;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class MortarRecipeCategory
implements IRecipeCategory<MortarRecipe> {
    public static final RecipeType<MortarRecipe> MORTAR = RecipeType.create((String)"pizzacraft", (String)"mortar", MortarRecipe.class);
    public static final ResourceLocation ID = new ResourceLocation("pizzacraft", "mortar");
    private final IDrawable background;
    private final IDrawable icon;
    private final Component title;

    public MortarRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(new ResourceLocation("pizzacraft", "textures/gui/mortar_recipe.png"), -9, -9, 128, 96);
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)ModBlocks.MORTAR_AND_PESTLE.get()));
        this.title = Component.m_237115_((String)"recipecategory.pizzacraft.mortar");
    }

    public RecipeType<MortarRecipe> getRecipeType() {
        return MORTAR;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MortarRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.OUTPUT, 98, 40).addItemStack(recipe.m_8043_());
        for (int i = 0; i < recipe.getInputs().size(); ++i) {
            builder.addSlot(RecipeIngredientRole.INPUT, 10, 70 - (18 * i + i * 2)).addIngredients((Ingredient)recipe.getInputs().get(i));
        }
    }

    public void draw(MortarRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack poseStack, double mouseX, double mouseY) {
        Font font = Minecraft.m_91087_().f_91062_;
        String duration = recipe.getDuration() + "x";
        font.m_92883_(poseStack, duration, 44.0f - (float)font.m_92895_(duration) / 2.0f, 27.0f, -12566464);
    }
}

